import grpc
import sys
import pickle
sys.path.insert(0, '../protos/')
import deepcam_pb2
import deepcam_pb2_grpc
import numpy as np  
import cv2 as cv
import time
import threading

img_w = 640
img_h = 480
img_ch = 3

rgb_img = np.zeros((img_w, img_h, img_ch), dtype="uint8")
stop_capture = False

def thread_capture_cam(name):
    print("Capture Starting")
    # cap = cv.VideoCapture(0)
    cap = cv.VideoCapture('../videos/video1.mp4')
    global rgb_img
    while True:
        ret, rgb_img = cap.read()
        time.sleep(0.001)
        if stop_capture or ret == False:
            break
    print("Video End")
    cap.release()
 
def main():
    # Connect to server
    # channel = grpc.insecure_channel('35.229.176.12:2000')
    channel = grpc.insecure_channel('34.80.18.226:2000')
    # channel = grpc.insecure_channel('0.0.0.0:2000')
    stub = deepcam_pb2_grpc.DeepCamStub(channel)
    # Send request to server
    img_msg = deepcam_pb2.SendImgMessage()
    # cap = cv.VideoCapture(0)

    x = threading.Thread(target=thread_capture_cam, args=(1,))
    x.start()
    
    global rgb_img
    # print(rgb_img)
    while True:
        tstart_time = time.time()
        # start_time = time.time()
        # rgb_img = cv.imread('../images/image1.jpg')
        # ret, rgb_img = cap.read()
        # elapsed_time = time.time() - start_time
        # print("\n\nRead Image :", elapsed_time)
        # print(rgb_img)
        # start_time = time.time()
        # rgb_img_small = cv.resize(rgb_img, (320, 240), interpolation = cv.INTER_AREA)
        # elapsed_time = time.time() - start_time
        # print("Resize Image :", elapsed_time)

        start_time = time.time()
        _, rgb_img_bytes = cv.imencode('.jpg', rgb_img)
        rgb_img_bytes = rgb_img_bytes.tobytes()
        elapsed_time = time.time() - start_time
        print("Encode Image :", elapsed_time)

        start_time = time.time()
        img_msg.img_w = img_w
        img_msg.img_h = img_h
        img_msg.img_ch = img_ch
        img_msg.img_data = rgb_img_bytes
        elapsed_time = time.time() - start_time
        print("Fill Data :", elapsed_time)

        start_time = time.time()
        reply_msg = stub.DetectionRequest(img_msg)
        elapsed_time = time.time() - start_time
        print("Client-Server Comm :", elapsed_time)

        start_time = time.time()
        img_from_server = np.frombuffer(reply_msg.img_data, dtype="uint8")
        img_from_server = cv.imdecode(img_from_server, 1)
        elapsed_time = time.time() - start_time
        print("Decode Image :", elapsed_time)

        telapsed_time = time.time() - tstart_time
        print("FPS :", 1 / telapsed_time)
        cv.imshow('Cloud Based CNN Result', img_from_server)
        key = cv.waitKey(1)
        if key == ord('x'):
            global stop_capture
            stop_capture = True
            break
    x.join()
    cv.destroyAllWindows()

if __name__ == "__main__":
    main()