import grpc
import sys
import pickle
sys.path.insert(0, '../protos/')
import deepcam_pb2
import deepcam_pb2_grpc
import numpy as np  
import cv2 as cv
import time
import colorsys

def main():
    # Open Class Files
    f = open("./data/coco.names","r")
    contents = f.readlines()
    classes = []
    for content in contents:
        classes.append(content.rstrip())

    # Create Color Map
    hsv_tuples = [( x / len(classes), 0.9, 1.0) for x in range(len(classes))]
    colors = list(map(lambda x: colorsys.hsv_to_rgb(*x), hsv_tuples))
    colors = list(map(lambda x: (int(x[0] * 255), int(x[1] * 255), int(x[2] * 255)), colors))

    # Connect to server
    # channel = grpc.insecure_channel('35.229.176.12:2000')
    channel = grpc.insecure_channel('34.80.18.226:2000')
    stub = deepcam_pb2_grpc.DeepCamStub(channel)

    # Define Image Message
    img_msg = deepcam_pb2.ImgMessage()

    # Webcam Video Capture
    cap = cv.VideoCapture(0)

    while True:
        tstart_time = time.time()

        # Grab an Image
        start_time = time.time()
        ret, rgb_img = cap.read()
        if ret == False:
            break
        elapsed_time = time.time() - start_time
        print("\n\nRead Image :", elapsed_time)

        # Resize
        start_time = time.time()
        # rgb_img = cv.resize(rgb_img,(1920,1080))
        # rgb_img = cv.resize(rgb_img,(1600,896))
        # rgb_img = cv.resize(rgb_img,(1280,720))
        # rgb_img = cv.resize(rgb_img,(1024,576))
        # rgb_img = cv.resize(rgb_img,(960,540))
        # rgb_img = cv.resize(rgb_img,(848,480))
        # rgb_img = cv.resize(rgb_img,(800,600))
        # rgb_img = cv.resize(rgb_img,(800,448))
        rgb_img = cv.resize(rgb_img,(640,480))
        elapsed_time = time.time() - start_time
        print("Resize Image :", elapsed_time * 1000)

        # Encode to JPG format
        start_time = time.time()
        _, rgb_img_bytes = cv.imencode('.jpg', rgb_img)
        img_msg.img_data = rgb_img_bytes.tobytes()
        elapsed_time = time.time() - start_time
        print("Encode Image :", elapsed_time * 1000)

        # Detection Request to Server
        start_time = time.time()
        reply_msg = stub.YOLORequest(img_msg)
        elapsed_time = time.time() - start_time
        print("Client-Server Comm :", elapsed_time * 1000)
        
        # Convert Reply data from Server to numpy array
        boxes = np.frombuffer(reply_msg.boxes, dtype=np.float32)
        scores = np.frombuffer(reply_msg.scores, dtype=np.float32)
        labels = np.frombuffer(reply_msg.labels, dtype=np.int32)
        if len(labels) > 0:
            boxes = boxes.reshape((labels.shape[0], boxes.shape[0] // labels.shape[0]))

        # Draw Detection Results
        start_time = time.time()
        for i in range(len(labels)):
            bbox, score, label = boxes[i], scores[i], classes[labels[i]]
            bbox_text = "%s %.2f" %(label, score)
            # Convert bounding box to original image ratio
            detection_size, original_size = np.array([416, 416]), np.array([rgb_img.shape[1], rgb_img.shape[0]])
            ratio = original_size / detection_size
            bbox = list((bbox.reshape(2,2) * ratio).reshape(-1))

            # Draw object bounding box
            cv.rectangle(rgb_img,(int(bbox[0]),int(bbox[1])),(int(bbox[2]),int(bbox[3])),colors[labels[i]],2)
            
            # Draw text classes
            text_size, _ = cv.getTextSize(bbox_text, cv.FONT_HERSHEY_SIMPLEX, 0.7, 1)
            text_w, text_h = text_size
            cv.rectangle(rgb_img,(int(bbox[0]),int(bbox[1])),(int(bbox[0] + text_w),int(bbox[1] - text_h)),colors[labels[i]],-1)
            cv.putText(rgb_img,bbox_text,(int(bbox[0]),int(bbox[1])), cv.FONT_HERSHEY_SIMPLEX, 0.5,(255,255,255),1,cv.LINE_AA)
        elapsed_time = time.time() - start_time
        print("Draw Bounding Box :", elapsed_time * 1000)
        
        # Measure FPS
        telapsed_time = time.time() - tstart_time
        fps =  1000 / (telapsed_time * 1000)
        print("Total time :", telapsed_time)
        print("FPS :", fps)

        fps_text = "FPS : %.2f" %(fps)
        cv.putText(rgb_img, fps_text, (50,50), cv.FONT_HERSHEY_SIMPLEX, 1,(0,0,255),2,cv.LINE_AA)

        # Show the detection result
        cv.imshow('Cloud Based CNN Result', rgb_img)
        key = cv.waitKey(1)
        if key == ord('x'):
            break
        
        

    cv.destroyAllWindows()

if __name__ == "__main__":
    main()