from concurrent import futures
import time
import logging
import sys
import grpc
import numpy as np 
import cv2 as cv
import pickle
sys.path.insert(0, '../protos/')
import deepcam_pb2
import deepcam_pb2_grpc

# Tensorflow dependencies
import os
import six.moves.urllib as urllib
import tarfile
import tensorflow as tf
import zipfile
from distutils.version import StrictVersion
from collections import defaultdict
from io import StringIO
# from matplotlib import pyplot as plt
from PIL import Image
from object_detection.utils import ops as utils_ops
from object_detection.utils import label_map_util
from object_detection.utils import visualization_utils as vis_util

# sys.path.append("./object_detection/")

if StrictVersion(tf.__version__) < StrictVersion('1.12.0'):
    raise ImportError('Please upgrade your TensorFlow installation to v1.12.*.')

_ONE_DAY_IN_SECONDS = 60 * 60 * 24

global detection_graph
global category_index

class DeepCam(deepcam_pb2_grpc.DeepCamServicer):
    def PleaseReply(self, request, context):
        print("Received :", request.msg_number)
        return deepcam_pb2.ReplyMessage(msg_recv='Hello, %s!' % request.msg_send)

    def DetectionRequest(self, request, context):
        bbox_array = np.ones((5), dtype=int)

        bbox_array_bytes = bbox_array.tobytes()
        rgb_img = np.frombuffer(request.img_data, dtype="uint8")
        rgb_img = cv.imdecode(rgb_img, 1)

        rgb_img_expanded = np.expand_dims(rgb_img, axis=0)

        # Proses deteksi
        pil_rgb_img = Image.fromarray(rgb_img)
        global detection_graph
        output_dict = run_inference_for_single_image(rgb_img_expanded, detection_graph)
        
        vis_util.visualize_boxes_and_labels_on_image_array(
            rgb_img,
            output_dict['detection_boxes'],
            output_dict['detection_classes'],
            output_dict['detection_scores'],
            category_index,
            instance_masks=output_dict.get('detection_masks'),
            use_normalized_coordinates=True,
            line_thickness=2)

        _, rgb_img_bytes = cv.imencode('.jpg', rgb_img)
        rgb_img_bytes = rgb_img_bytes.tobytes()
        
        img_h, img_w, img_ch = rgb_img.shape
        return deepcam_pb2.ReplyImgMessage(img_h=img_h, img_w=img_w, img_ch=img_ch, img_data=rgb_img_bytes, bbox_result=bbox_array_bytes)

def load_tf_model():
    # Load model first
    MODEL_NAME = 'ssd_mobilenet_v1_coco_2017_11_17'
    # MODEL_NAME = 'ssdlite_mobilenet_v2_coco_2018_05_09'
    MODEL_FILE = MODEL_NAME + '.tar.gz'
    DOWNLOAD_BASE = 'http://download.tensorflow.org/models/object_detection/'
    PATH_TO_FROZEN_GRAPH = MODEL_NAME + '/frozen_inference_graph.pb'
    PATH_TO_LABELS = os.getcwd() + '/object_detection/data/mscoco_label_map.pbtxt'
    # print(PATH_TO_LABELS)
    # Download Model
    opener = urllib.request.URLopener()
    opener.retrieve(DOWNLOAD_BASE + MODEL_FILE, MODEL_FILE)
    tar_file = tarfile.open(MODEL_FILE)
    for file in tar_file.getmembers():
        file_name = os.path.basename(file.name)
        if 'frozen_inference_graph.pb' in file_name:
            tar_file.extract(file, os.getcwd())

    global detection_graph
    detection_graph = tf.Graph()
    with detection_graph.as_default():
        od_graph_def = tf.GraphDef()
        with tf.gfile.GFile(PATH_TO_FROZEN_GRAPH, 'rb') as fid:
            serialized_graph = fid.read()
            od_graph_def.ParseFromString(serialized_graph)
            tf.import_graph_def(od_graph_def, name='')
    
    global category_index
    category_index = label_map_util.create_category_index_from_labelmap(PATH_TO_LABELS, use_display_name=True)

def run_inference_for_single_image(image, graph):
    with graph.as_default():
        config = tf.ConfigProto()
        with tf.Session() as sess:
            # Get handles to input and output tensors
            ops = tf.get_default_graph().get_operations()
            all_tensor_names = {output.name for op in ops for output in op.outputs}
            tensor_dict = {}
            for key in ['num_detections', 'detection_boxes', 'detection_scores', 'detection_classes', 'detection_masks']:
                tensor_name = key + ':0'
                if tensor_name in all_tensor_names:
                    tensor_dict[key] = tf.get_default_graph().get_tensor_by_name(tensor_name)
            if 'detection_masks' in tensor_dict:
                # The following processing is only for single image
                detection_boxes = tf.squeeze(tensor_dict['detection_boxes'], [0])
                detection_masks = tf.squeeze(tensor_dict['detection_masks'], [0])
                # Reframe is required to translate mask from box coordinates to image coordinates and fit the image size.
                real_num_detection = tf.cast(tensor_dict['num_detections'][0], tf.int32)
                detection_boxes = tf.slice(detection_boxes, [0, 0], [real_num_detection, -1])
                detection_masks = tf.slice(detection_masks, [0, 0, 0], [real_num_detection, -1, -1])
                detection_masks_reframed = utils_ops.reframe_box_masks_to_image_masks(detection_masks, detection_boxes, image.shape[1], image.shape[2])
                detection_masks_reframed = tf.cast(tf.greater(detection_masks_reframed, 0.5), tf.uint8)
                # Follow the convention by adding back the batch dimension
                tensor_dict['detection_masks'] = tf.expand_dims(detection_masks_reframed, 0)
            image_tensor = tf.get_default_graph().get_tensor_by_name('image_tensor:0')

            # Run inference
            output_dict = sess.run(tensor_dict, feed_dict={image_tensor: image})

            # all outputs are float32 numpy arrays, so convert types as appropriate
            output_dict['num_detections'] = int(output_dict['num_detections'][0])
            output_dict['detection_classes'] = output_dict['detection_classes'][0].astype(np.int64)
            output_dict['detection_boxes'] = output_dict['detection_boxes'][0]
            output_dict['detection_scores'] = output_dict['detection_scores'][0]
            if 'detection_masks' in output_dict:
                output_dict['detection_masks'] = output_dict['detection_masks'][0]
    return output_dict

def serve():
    load_tf_model()
    # config = tf.ConfigProto()
    # sess = tf.Session(config=config)
    # Run server
    server = grpc.server(futures.ThreadPoolExecutor(max_workers=10))
    deepcam_pb2_grpc.add_DeepCamServicer_to_server(DeepCam(), server)
    # server.add_insecure_port('[::]:50051')
    server.add_insecure_port('[::]:2000')
    server.start()
    print("Server Running")
    try:
        while True:
            time.sleep(_ONE_DAY_IN_SECONDS)
    except KeyboardInterrupt:
        server.stop(0)

def main():
    load_tf_model()
    global detection_graph
    global category_index
    for i in range(10):
        rgb_img = cv.imread("../images/image1.jpg", 1)

        rgb_img_expanded = np.expand_dims(rgb_img, axis=0)
        tstart = time.time()
        # Proses deteksi
        output_dict = run_inference_for_single_image(rgb_img_expanded, detection_graph)
        
        vis_util.visualize_boxes_and_labels_on_image_array(
            rgb_img,
            output_dict['detection_boxes'],
            output_dict['detection_classes'],
            output_dict['detection_scores'],
            category_index,
            instance_masks=output_dict.get('detection_masks'),
            use_normalized_coordinates=True,
            line_thickness=2)
        telapsed = time.time() - tstart
        print("FPS : ", 1/telapsed)

if __name__ == '__main__':
    # logging.basicConfig()
    main()